<?= $this->extend('layouts/modelo_layout') ?>

<?= $this->section('content') ?>
<div class="p-6 md:p-10 max-w-7xl mx-auto w-full">
    
    <div class="text-center mb-12">
        <h2 class="text-white text-3xl md:text-4xl font-black uppercase tracking-tighter mb-2">Impulsa tu Perfil</h2>
        <p class="text-text-muted text-sm italic italic">Selecciona el plan que mejor se adapte a tus necesidades para maximizar tus contactos.</p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-8 items-end">
        
        <div class="bg-surface-dark border border-border-dark rounded-3xl p-8 flex flex-col hover:border-primary/30 transition-all shadow-xl">
            <h3 class="text-white font-bold text-xl mb-1 uppercase tracking-tight">Independent Models</h3>
            <p class="text-text-muted text-xs mb-6">Visibilidad estándar en el sitio.</p>
            <div class="text-3xl font-black text-white mb-6">$15.000 <span class="text-xs font-normal text-text-muted">/ 30 días</span></div>
            
            <ul class="space-y-4 mb-8 flex-1 text-gray-300 text-sm font-medium">
                <li class="flex items-center gap-2"><span class="material-symbols-outlined text-emerald-500 text-sm">check_circle</span> Perfil verificado</li>
                <li class="flex items-center gap-2"><span class="material-symbols-outlined text-emerald-500 text-sm">check_circle</span> Galería de fotos y videos</li>
                <li class="flex items-center gap-2 text-gray-600"><span class="material-symbols-outlined text-sm">cancel</span> Lugar prioritario</li>
            </ul>
            <button onclick="abrirPago('NORMAL', '$15.000')" class="w-full py-3 rounded-xl border border-border-dark text-white font-black text-xs uppercase hover:bg-white hover:text-black transition-all">Seleccionar</button>
        </div>

        <div class="bg-yellow-500/5 border-2 border-yellow-500 rounded-3xl p-8 flex flex-col relative transform lg:scale-110 shadow-2xl shadow-yellow-500/10 z-10">
            <div class="absolute -top-4 left-1/2 -translate-x-1/2 bg-yellow-500 text-black text-[10px] font-black px-4 py-1 rounded-full uppercase tracking-widest shadow-lg">Más Popular</div>
            <h3 class="text-yellow-500 font-black text-2xl mb-1 uppercase italic">VIP Gold</h3>
            <p class="text-yellow-500/60 text-xs mb-6 font-bold uppercase tracking-widest">Máxima exposición</p>
            <div class="text-4xl font-black text-white mb-6">$45.000 <span class="text-xs font-normal text-text-muted">/ 30 días</span></div>
            
            <ul class="space-y-4 mb-8 flex-1 text-gray-200 text-sm font-bold italic">
                <li class="flex items-center gap-2"><span class="material-symbols-outlined text-yellow-500 text-sm">stars</span> Primeros lugares siempre</li>
                <li class="flex items-center gap-2"><span class="material-symbols-outlined text-yellow-500 text-sm">stars</span> Borde dorado en el Home</li>
                <li class="flex items-center gap-2"><span class="material-symbols-outlined text-yellow-500 text-sm">stars</span> Etiqueta VIP destacada</li>
                <li class="flex items-center gap-2"><span class="material-symbols-outlined text-yellow-500 text-sm">stars</span> Historias destacadas</li>
            </ul>
            <button onclick="abrirPago('VIP GOLD', '$45.000')" class="w-full py-4 rounded-xl bg-yellow-500 text-black font-black text-xs uppercase hover:brightness-110 transition-all shadow-lg shadow-yellow-500/30">Contratar VIP</button>
        </div>

        <div class="bg-surface-dark border border-border-dark rounded-3xl p-8 flex flex-col hover:border-primary/30 transition-all shadow-xl">
            <h3 class="text-white font-bold text-xl mb-1 uppercase tracking-tight">Premium Selection</h3>
            <p class="text-text-muted text-xs mb-6">Mejor posición que el normal.</p>
            <div class="text-3xl font-black text-white mb-6">$30.000 <span class="text-xs font-normal text-text-muted">/ 30 días</span></div>
            
            <ul class="space-y-4 mb-8 flex-1 text-gray-300 text-sm font-medium">
                <li class="flex items-center gap-2"><span class="material-symbols-outlined text-emerald-500 text-sm">check_circle</span> Posición media en Home</li>
                <li class="flex items-center gap-2"><span class="material-symbols-outlined text-emerald-500 text-sm">check_circle</span> Sello de verificación</li>
                <li class="flex items-center gap-2"><span class="material-symbols-outlined text-emerald-500 text-sm">check_circle</span> Prioridad sobre Normales</li>
            </ul>
            <button onclick="abrirPago('PREMIUM', '$30.000')" class="w-full py-3 rounded-xl border border-border-dark text-white font-black text-xs uppercase hover:bg-white hover:text-black transition-all">Seleccionar</button>
        </div>
    </div>

    <div id="modalPago" class="fixed inset-0 bg-black/90 backdrop-blur-md hidden z-[100] flex items-center justify-center p-4">
    <div class="bg-surface-dark border border-border-dark w-full max-w-md rounded-3xl p-8 shadow-2xl">
        <div class="flex justify-between items-start mb-6">
            <div>
                <h3 class="text-white text-xl font-black uppercase tracking-tight">Activar Mi Plan</h3>
                <p class="text-text-muted text-xs mt-1">Plan: <span id="txtPlan" class="text-primary font-black uppercase italic"></span></p>
            </div>
            <button onclick="cerrarPago()" class="text-gray-500 hover:text-white transition-colors">
                <span class="material-symbols-outlined">close</span>
            </button>
        </div>
        
        <div class="space-y-4">
            <div class="bg-emerald-500/5 border border-emerald-500/20 p-6 rounded-2xl relative group">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center gap-3">
                        <span class="material-symbols-outlined text-emerald-500 text-2xl">account_balance</span>
                        <span class="text-emerald-500 font-black text-xs uppercase tracking-widest">Datos de Transferencia</span>
                    </div>
                    <button onclick="copiarDatosTodo()" class="text-[10px] font-black text-emerald-500 hover:text-white bg-emerald-500/10 px-2 py-1 rounded-md transition-all flex items-center gap-1">
                        <span class="material-symbols-outlined text-xs">content_copy</span> COPIAR TODO
                    </button>
                </div>

                <div id="datosTransferencia" class="text-gray-300 text-[11px] space-y-2 leading-relaxed">
                    <div class="flex justify-between items-center border-b border-emerald-500/10 pb-1">
                        <span>Banco: <strong class="text-white">Banco Estado</strong></span>
                    </div>
                    <div class="flex justify-between items-center border-b border-emerald-500/10 pb-1">
                        <span>Tipo: <strong class="text-white">Cuenta RUT</strong></span>
                    </div>
                    <div class="flex justify-between items-center border-b border-emerald-500/10 pb-1">
                        <span>Cuenta: <strong id="valCuenta" class="text-white">17143285</strong></span>
                        <button onclick="copiarTexto('17143285-5', this)" class="text-emerald-500 hover:text-white"><span class="material-symbols-outlined text-sm">content_copy</span></button>
                    </div>
                    <div class="flex justify-between items-center border-b border-emerald-500/10 pb-1">
                        <span>RUT: <strong id="valRut" class="text-white">17.143.285-5</strong></span>
                        <button onclick="copiarTexto('17.143.285-5', this)" class="text-emerald-500 hover:text-white"><span class="material-symbols-outlined text-sm">content_copy</span></button>
                    </div>
                    <div class="flex justify-between items-center border-b border-emerald-500/10 pb-1">
                        <span>Nombre: <strong id="valNombre" class="text-white">Elias Figueroa</strong></span>
                        <button onclick="copiarTexto('Elias Figueroa', this)" class="text-emerald-500 hover:text-white"><span class="material-symbols-outlined text-sm">content_copy</span></button>
                    </div>
                    <div class="flex justify-between items-center">
                        <span>Mail: <strong id="valMail" class="text-white">klientitasexshop@gmail.com</strong></span>
                        <button onclick="copiarTexto('klientitasexshop@gmail.com', this)" class="text-emerald-500 hover:text-white"><span class="material-symbols-outlined text-sm">content_copy</span></button>
                    </div>
                </div>

                <a id="btnWhatsAppComprobante" href="#" target="_blank" class="mt-6 flex items-center justify-center gap-2 bg-emerald-500 text-white w-full py-4 rounded-xl font-black text-xs uppercase tracking-widest shadow-lg shadow-emerald-500/20 hover:scale-[1.02] transition-all">
                    <span class="material-symbols-outlined text-sm">send</span> Enviar Comprobante
                </a>
            </div>

            </div>
    </div>
</div>
</div>
<div class="h-32 lg:hidden w-full"></div>
<script>

// Función para copiar texto individual
function copiarTexto(texto, btn) {
    navigator.clipboard.writeText(texto).then(() => {
        const originalIcon = btn.innerHTML;
        btn.innerHTML = '<span class="material-symbols-outlined text-sm text-white">done</span>';
        setTimeout(() => {
            btn.innerHTML = originalIcon;
        }, 1500);
    });
}

// Función para copiar todos los datos formateados
function copiarDatosTodo() {
    const datos = `Banco: Banco Estado
Tipo: Cuenta RUT
Cuenta: 17143285-5
RUT: 17.143.285-5
Nombre: Elias Figueroa
Mail: klientitasexshop@gmail.com`;

    navigator.clipboard.writeText(datos).then(() => {
        alert("¡Todos los datos copiados al portapapeles!");
    });
}


// Obtenemos los datos desde PHP
const nombreModelo = "<?= $modelo['nombre_artistico'] ?? session()->get('nombre') ?? 'Modelo' ?>";
const idModelo = "<?= $modelo['id'] ?? 'N/A' ?>"; // Traemos el ID único de la base de datos

function abrirPago(plan, precio) {
    const txtPlan = plan + ' (' + precio + ')';
    document.getElementById('txtPlan').innerText = txtPlan;
    
    /**
     * Construcción del mensaje profesional:
     * Incluye ID, Nombre y Plan para que el admin identifique la cuenta al instante.
     */
    const mensajeTexto = `¡Hola! Soy ${nombreModelo} (ID: ${idModelo}). ` + 
                         `Acabo de realizar la transferencia para activar mi plan ${plan}. ` +
                         `Adjunto el comprobante para su validación.`;

    const mensajeEncoded = encodeURIComponent(mensajeTexto);
    const urlWhatsApp = `https://wa.me/56963744955?text=${mensajeEncoded}`;
    
    // Actualizar el enlace del botón en el modal
    const btnWA = document.getElementById('btnWhatsAppComprobante');
    btnWA.href = urlWhatsApp;
    
    // Mostrar modal
    document.getElementById('modalPago').classList.remove('hidden');
}

function cerrarPago() {
    document.getElementById('modalPago').classList.add('hidden');
}
</script>
<?= $this->endSection() ?>