<?= $this->extend('layouts/modelo_layout') ?>

<?= $this->section('content') ?>
<div class="flex flex-col gap-8 p-6 lg:p-10 max-w-7xl mx-auto w-full">
    
    <div class="flex flex-col gap-6 md:flex-row md:items-end md:justify-between">
        <div class="flex flex-col gap-2">
            <h2 class="text-white text-3xl md:text-4xl font-black tracking-tight uppercase">Panel de Control</h2>
            <p class="text-text-muted text-base italic">Bienvenida de nuevo, <?= explode(' ', $usuario)[0] ?>.</p>
        </div>
        
        <div class="flex items-center gap-4 bg-surface-dark p-2 pl-5 pr-2 rounded-full border border-[#39282c] shadow-lg">
            <div class="flex items-center gap-3">
                <div class="flex size-2 relative">
                    <span id="ping-disponible" class="<?= ($modelo['disponible_ahora'] == 1) ? 'animate-ping' : 'hidden' ?> absolute inline-flex h-full w-full rounded-full bg-emerald-400 opacity-75"></span>
                    <span id="dot-disponible" class="relative inline-flex rounded-full size-2 <?= ($modelo['disponible_ahora'] == 1) ? 'bg-emerald-500' : 'bg-zinc-600' ?>"></span>
                </div>
                <span class="text-white text-sm font-bold whitespace-nowrap">Disponible Ahora</span>
            </div>
            
            <label class="relative flex h-[28px] w-[48px] cursor-pointer items-center rounded-full border-none bg-[#39282c] p-1 transition-colors has-[:checked]:bg-primary shadow-inner">
                <input id="switch-disponibilidad" type="checkbox" class="peer invisible absolute" <?= ($modelo['disponible_ahora'] == 1) ? 'checked' : '' ?> />
                <div class="h-5 w-5 rounded-full bg-white shadow-sm transition-all peer-checked:translate-x-5"></div>
            </label>
        </div>
    </div>

    <?php
        $hoy = new DateTime();
        $expiracion = !empty($modelo['plan_expiracion']) ? new DateTime($modelo['plan_expiracion']) : null;
        $planActivo = ($expiracion && $expiracion > $hoy);
        $diasRestantes = $planActivo ? $hoy->diff($expiracion)->format('%a') : 0;

        $paso1 = true; // Registro
        $paso2 = (($modelo['verificada'] ?? 0) == 1); // Identidad
        $paso3 = ($paso2 && $planActivo); // Perfil Online
    ?>

    <div class="max-w-4xl mx-auto w-full mb-4 p-8 bg-surface-dark rounded-3xl border border-border-dark shadow-2xl">
        <h3 class="text-[10px] font-black text-gray-500 uppercase tracking-[0.2em] mb-10 text-center">Estado de tu incorporaci&oacute;n</h3>
        
        <div class="relative flex items-center justify-between">
            <div class="absolute left-0 top-1/2 h-0.5 w-full -translate-y-1/2 bg-white/10"></div>
            <div class="absolute left-0 top-1/2 h-0.5 -translate-y-1/2 bg-gold transition-all duration-700" 
                 style="width: <?= $paso3 ? '100%' : ($paso2 ? '50%' : '0%') ?>;"></div>

            <div class="relative z-10 flex flex-col items-center">
                <div class="flex size-10 items-center justify-center rounded-full bg-gold text-black shadow-[0_0_15px_rgba(238,189,43,0.4)]">
                    <span class="material-symbols-outlined text-sm font-bold">check</span>
                </div>
                <span class="absolute -bottom-8 whitespace-nowrap text-[10px] font-black uppercase tracking-tighter text-gold">Registro OK</span>
            </div>

            <div class="relative z-10 flex flex-col items-center">
                <div class="flex size-10 items-center justify-center rounded-full border-2 transition-all duration-500 <?= $paso2 ? 'bg-gold border-gold text-black shadow-[0_0_15px_rgba(238,189,43,0.4)]' : 'bg-surface-dark border-white/10 text-white/20' ?>">
                    <span class="material-symbols-outlined text-sm font-bold"><?= $paso2 ? 'check' : 'fingerprint' ?></span>
                </div>
                <span class="absolute -bottom-8 whitespace-nowrap text-[10px] font-black uppercase tracking-tighter <?= $paso2 ? 'text-gold' : 'text-gray-600' ?>">Identidad</span>
            </div>

            <div class="relative z-10 flex flex-col items-center">
                <div class="flex size-10 items-center justify-center rounded-full border-2 transition-all duration-500 <?= $paso3 ? 'bg-gold border-gold text-black shadow-[0_0_15px_rgba(238,189,43,0.4)]' : 'bg-surface-dark border-white/10 text-white/20' ?>">
                    <span class="material-symbols-outlined text-sm font-bold"><?= $paso3 ? 'check' : 'rocket_launch' ?></span>
                </div>
                <span class="absolute -bottom-8 whitespace-nowrap text-[10px] font-black uppercase tracking-tighter <?= $paso3 ? 'text-gold' : 'text-gray-600' ?>">Perfil Online</span>
            </div>
        </div>
    </div>

    <div class="space-y-4">
        <?php if (!$paso2): ?>
            <?php 
                $enRevision = !empty($modelo['documento_identidad']); 
                $motivoRechazo = !empty($modelo['observaciones_admin']);
                $cardStyle = $enRevision ? 'border-blue-500/30 bg-blue-500/5 text-blue-400' : ($motivoRechazo ? 'border-red-500/30 bg-red-500/5 text-red-500' : 'border-yellow-500/30 bg-yellow-500/5 text-yellow-500');
            ?>
            <div class="rounded-2xl border p-6 <?= $cardStyle ?> flex flex-col md:flex-row items-center gap-6 shadow-xl">
                <span class="material-symbols-outlined text-4xl"><?= $enRevision ? 'sync' : 'report' ?></span>
                <div class="flex-1 text-center md:text-left">
                    <h3 class="font-black uppercase tracking-wider italic"><?= $enRevision ? 'Verificaci&oacute;n en Proceso' : 'Acci&oacute;n Requerida' ?></h3>
                    <p class="text-sm opacity-80"><?= $enRevision ? 'Estamos revisando tus documentos de identidad.' : ($motivoRechazo ? 'Rechazado: ' . esc($modelo['observaciones_admin']) : 'Sube tus fotos de identidad para validar tu cuenta.') ?></p>
                </div>
                <?php if (!$enRevision): ?>
                    <a href="<?= base_url('modelo/editar-ficha') ?>" class="bg-white text-black px-6 py-3 rounded-xl font-bold text-xs uppercase hover:scale-105 transition-transform">Subir Documentos</a>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ($paso2 && !$paso3): ?>
            <div class="bg-primary/10 border border-primary/30 p-6 rounded-3xl flex flex-col md:flex-row items-center gap-6 animate-pulse shadow-xl">
                <div class="flex-1 text-center md:text-left">
                    <h3 class="text-primary font-black uppercase text-sm italic">&iexcl;Identidad Aprobada!</h3>
                    <p class="text-white/80 text-xs">Ya validamos tus datos. Ahora activa un plan para que los clientes puedan verte en el sitio.</p>
                </div>
                <a href="<?= base_url('modelo/planes') ?>" class="bg-primary text-white px-8 py-4 rounded-xl font-black text-xs uppercase tracking-widest shadow-lg shadow-primary/20 hover:scale-105 transition-all">VER PLANES DISPONIBLES</a>
            </div>
        <?php endif; ?>

        <?php if ($paso3): ?>
            <div class="bg-emerald-500/10 border border-emerald-500/40 p-5 rounded-2xl flex justify-between items-center shadow-lg">
                <div class="flex items-center gap-3 text-white text-xs font-bold uppercase">
                    <span class="material-symbols-outlined text-emerald-500 font-variation-settings: 'FILL' 1">verified_user</span> 
                    PLAN <?= strtoupper($modelo['membresia']) ?> ACTIVO
                </div>
                <span class="text-emerald-500 text-[10px] font-black italic">Expira en <?= $diasRestantes ?> d&iacute;as</span>
            </div>
        <?php endif; ?>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-5">
        <div class="flex flex-col gap-3 rounded-2xl p-6 bg-surface-dark border border-[#2a1d21] group hover:border-primary/20 transition-all">
            <div class="flex items-center justify-between">
                <span class="material-symbols-outlined text-primary">visibility</span>
                <span class="text-text-muted text-[10px] font-black uppercase tracking-widest">Vistas</span>
            </div>
            <div>
                <p class="text-white text-4xl font-black italic"><?= number_format($vistas ?? 0, 0, ',', '.') ?></p>
                <p class="text-[10px] text-gray-500 mt-2 leading-tight">Veces que usuarios han entrado a mirar tu ficha completa.</p>
            </div>
        </div>

        <div class="flex flex-col gap-3 rounded-2xl p-6 bg-surface-dark border border-[#2a1d21] group hover:border-primary/20 transition-all">
            <div class="flex items-center justify-between">
                <span class="material-symbols-outlined text-primary">ads_click</span>
                <span class="text-text-muted text-[10px] font-black uppercase tracking-widest">Clics Contacto</span>
            </div>
            <div>
                <p class="text-white text-4xl font-black italic"><?= number_format($clics ?? 0, 0, ',', '.') ?></p>
                <p class="text-[10px] text-gray-500 mt-2 leading-tight">Interesados que presionaron tu botón de WhatsApp o Teléfono.</p>
            </div>
        </div>

        <div class="flex flex-col gap-3 rounded-2xl p-6 bg-surface-dark border border-[#2a1d21] group hover:border-primary/50 transition-all">
            <div class="flex items-center justify-between">
                <span class="material-symbols-outlined text-primary font-variation-settings: 'FILL' 1">favorite</span>
                <span class="text-text-muted text-[10px] font-black uppercase tracking-widest">Fans (Favoritos)</span>
            </div>
            <div>
                <p class="text-white text-4xl font-black italic"><?= number_format($favoritos ?? 0, 0, ',', '.') ?></p>
                <p class="text-[10px] text-gray-500 mt-2 leading-tight">Usuarios que te guardaron para contactarte más adelante.</p>
            </div>
        </div>

        <div class="flex flex-col gap-3 rounded-2xl p-6 bg-gradient-to-br from-[#2a1d21] to-black border border-gold/30 group shadow-lg shadow-gold/5">
            <div class="flex items-center justify-between">
                <span class="material-symbols-outlined text-gold font-variation-settings: 'FILL' 1">emoji_events</span>
                <span class="text-gold/80 text-[10px] font-black uppercase tracking-widest">Tu Posicionamiento</span>
            </div>
            <div class="flex flex-col gap-2">
                <div class="flex items-baseline justify-between">
                    <p class="text-white text-3xl font-black italic">#<?= $pos_ciudad ?? '--' ?></p>
                    <span class="text-[9px] text-gold font-bold uppercase tracking-tighter">En su Ciudad</span>
                </div>
                <div class="w-full h-px bg-white/5"></div>
                <div class="flex items-baseline justify-between">
                    <p class="text-gray-400 text-xl font-black italic">#<?= $pos_global ?? '--' ?></p>
                    <span class="text-[8px] text-gray-600 font-bold uppercase tracking-tighter">A nivel Nacional</span>
                </div>
            </div>
            <p class="text-[9px] text-gold/40 mt-1 leading-tight italic">Comparamos tu popularidad local y global.</p>
        </div>
    </div>

    <div class="mt-8 p-6 rounded-2xl border flex flex-col md:flex-row items-center gap-5 transition-all
        <?= ($tipo_consejo == 'warning') ? 'bg-orange-500/5 border-orange-500/20' : '' ?>
        <?= ($tipo_consejo == 'primary') ? 'bg-primary/5 border-primary/20' : '' ?>
        <?= ($tipo_consejo == 'success') ? 'bg-emerald-500/5 border-emerald-500/20' : '' ?>
        <?= ($tipo_consejo == 'info') ? 'bg-blue-500/5 border-blue-500/20' : '' ?>
    ">
        <div class="size-14 rounded-2xl flex items-center justify-center shrink-0 shadow-lg
            <?= ($tipo_consejo == 'warning') ? 'bg-orange-500/20 text-orange-500' : '' ?>
            <?= ($tipo_consejo == 'primary') ? 'bg-primary/20 text-primary' : '' ?>
            <?= ($tipo_consejo == 'success') ? 'bg-emerald-500/20 text-emerald-500' : '' ?>
            <?= ($tipo_consejo == 'info') ? 'bg-blue-500/20 text-blue-500' : '' ?>
        ">
            <span class="material-symbols-outlined text-3xl font-variation-settings: 'FILL' 1">
                <?= ($tipo_consejo == 'warning') ? 'lightbulb' : (($tipo_consejo == 'success') ? 'verified_user' : 'rocket_launch') ?>
            </span>
        </div>
        
        <div class="flex-1 text-center md:text-left">
            <h4 class="text-white text-sm font-black uppercase tracking-widest mb-1">Consejo de tu Asistente</h4>
            <p class="text-gray-400 text-xs italic leading-relaxed">"<?= $consejo ?>"</p>
        </div>
    
        <div class="shrink-0">
            <a href="<?= base_url('modelo/editar-ficha') ?>" class="text-[10px] font-black uppercase tracking-widest px-6 py-3 rounded-xl border border-white/10 hover:bg-white/5 transition-all text-white inline-block">
                Mejorar Perfil
            </a>
        </div>
    </div>
</div>
<div class="h-32 lg:hidden w-full"></div>
<script>
document.getElementById('switch-disponibilidad').addEventListener('change', function() {
    const status = this.checked ? 1 : 0;
    fetch('<?= base_url('modelo/actualizar-disponibilidad') ?>', {
        method: 'POST',
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?= csrf_hash() ?>'
        },
        body: JSON.stringify({ disponible: status })
    })
    .then(res => res.json())
    .then(data => {
        if (!data.success) location.reload();
        document.getElementById('ping-disponible').classList.toggle('hidden', !this.checked);
        document.getElementById('dot-disponible').className = `relative inline-flex rounded-full size-2 ${this.checked ? 'bg-emerald-500' : 'bg-zinc-600'}`;
    });
});
</script>
<?= $this->endSection() ?>