<header class="sticky top-0 z-50 flex items-center justify-between whitespace-nowrap border-b border-solid border-white/5 bg-background-dark/95 backdrop-blur-md px-6 lg:px-10 py-3 shadow-lg">
    
    <a href="<?= base_url('/') ?>" class="flex items-center gap-4 text-white hover:opacity-90 transition-opacity">
        <div class="size-8 text-primary">
            <span class="material-symbols-outlined text-[32px]">local_fire_department</span>
        </div>
        <h2 class="text-white text-xl font-black leading-tight tracking-tighter uppercase italic">
            Calientitas<span class="text-primary">.cl</span>
        </h2>
    </a>

    <div class="hidden lg:flex flex-1 justify-end gap-8">
        <nav class="flex items-center gap-7">
            <a class="flex items-center gap-2 text-white hover:text-primary transition-all group font-black uppercase tracking-[2px] text-[10px]" href="<?= base_url('buscar') ?>">
                <span class="material-symbols-outlined text-primary text-[20px] group-hover:rotate-12 transition-transform">search</span>
                Buscar
            </a>

            <a class="text-white/60 hover:text-white transition-colors text-[10px] font-black uppercase tracking-widest" href="<?= base_url('/') ?>">Inicio</a>
            
            <a class="text-gold hover:text-gold-light transition-colors text-[10px] font-black flex items-center gap-1 uppercase tracking-widest" href="<?= base_url('buscar?categoria=vip') ?>">
                <span class="material-symbols-outlined text-[18px] font-variation-settings: 'FILL' 1">star</span> VIP
            </a>
            
            <a class="text-white/60 hover:text-white transition-colors text-[10px] font-black uppercase tracking-widest" href="<?= base_url('casting') ?>">Nuevas</a>
            
            <?php if(!session()->get('isLoggedIn')): ?>
                <a class="text-white/60 hover:text-white transition-colors text-[10px] font-black uppercase tracking-widest" href="<?= base_url('login') ?>">Ingresar</a>
            <?php endif; ?>
        </nav>

        <div class="flex items-center gap-3 border-l border-white/10 pl-8">
            
            <?php 
                $urlDestino = base_url('registro');
                $textoBoton = "Publicar Anuncio";
            
                if (session()->get('isLoggedIn')) {
                    switch (session()->get('rol')) {
                        case 'admin': $urlDestino = base_url('admin/dashboard'); $textoBoton = "Panel Admin"; break;
                        case 'modelo': $urlDestino = base_url('modelo/dashboard'); $textoBoton = "Mi Panel"; break;
                        case 'usuario': $urlDestino = base_url('usuario/panel'); $textoBoton = "Mi Perfil"; break;
                    }
                }
            ?>
            
            <a href="<?= $urlDestino ?>" class="flex cursor-pointer items-center justify-center overflow-hidden rounded-xl h-10 px-5 bg-primary hover:bg-primary/90 transition-all text-white text-[10px] font-black uppercase tracking-widest shadow-[0_0_15px_rgba(238,43,91,0.3)]">
                <span class="truncate"><?= $textoBoton ?></span>
            </a>

            <?php if(session()->get('isLoggedIn')): ?>
                <a href="<?= base_url('usuario/favoritas') ?>" class="flex size-10 cursor-pointer items-center justify-center rounded-xl bg-surface-dark hover:bg-white/10 transition-colors text-white border border-white/10 group" title="Mis Favoritas">
                    <span class="material-symbols-outlined group-hover:text-primary transition-colors">favorite</span>
                </a>

                <div class="relative group">
                    <button class="flex items-center gap-2 bg-surface-dark border border-white/10 p-1.5 pr-4 rounded-xl hover:border-primary/50 transition-all">
                        <div class="size-7 bg-primary rounded-lg flex items-center justify-center font-black text-[10px] text-white shadow-lg shadow-primary/20">
                            <?= strtoupper(substr(session()->get('nombre'), 0, 1)) ?>
                        </div>
                        <span class="text-[11px] font-black text-gray-300 uppercase tracking-tighter italic">
                            <?= explode(' ', session()->get('nombre'))[0] ?>
                        </span>
                        <span class="material-symbols-outlined text-gray-500 text-sm group-hover:text-primary transition-transform group-hover:rotate-180">expand_more</span>
                    </button>

                    <div class="absolute right-0 mt-3 w-52 bg-surface-dark border border-white/10 rounded-2xl shadow-2xl py-2 invisible group-hover:visible opacity-0 group-hover:opacity-100 transition-all z-[100] translate-y-2 group-hover:translate-y-0">
                        <div class="px-4 py-2 border-b border-white/5 mb-2">
                            <p class="text-[9px] text-gray-500 font-black uppercase tracking-widest">Gestionar Cuenta</p>
                        </div>
                        <a href="<?= $urlDestino ?>" class="flex items-center gap-3 px-4 py-2 text-[11px] font-bold text-gray-300 hover:text-white hover:bg-white/5 transition-colors">
                            <span class="material-symbols-outlined text-lg">account_circle</span> Mi Panel
                        </a>
                        <a href="<?= base_url('usuario/favoritas') ?>" class="flex items-center gap-3 px-4 py-2 text-[11px] font-bold text-gray-300 hover:text-white hover:bg-white/5 transition-colors">
                            <span class="material-symbols-outlined text-lg">favorite</span> Mis Favoritas
                        </a>
                        <div class="border-t border-white/5 my-2"></div>
                        <a href="<?= base_url('logout') ?>" class="flex items-center gap-3 px-4 py-2 text-[11px] font-bold text-primary hover:bg-primary/5 transition-colors">
                            <span class="material-symbols-outlined text-lg">logout</span> Cerrar Sesión
                        </a>
                    </div>
                </div>
            <?php else: ?>
                <a href="<?= base_url('login') ?>" class="flex size-10 cursor-pointer items-center justify-center rounded-xl bg-surface-dark hover:bg-white/10 transition-colors text-white border border-white/10" title="Iniciar Sesión">
                    <span class="material-symbols-outlined">account_circle</span>
                </a>
            <?php endif; ?>
        </div>
    </div>

    <div class="lg:hidden flex items-center gap-3">
        <a href="<?= base_url('buscar') ?>" class="size-9 flex items-center justify-center text-white/50 hover:text-primary transition-colors">
            <span class="material-symbols-outlined text-[28px]">search</span>
        </a>

        <?php if(session()->get('isLoggedIn')): ?>
             <a href="<?= $urlDestino ?>" class="size-9 bg-primary rounded-lg flex items-center justify-center font-black text-[10px] text-white shadow-lg shadow-primary/20">
                <?= strtoupper(substr(session()->get('nombre'), 0, 1)) ?>
            </a>
        <?php endif; ?>
        
        <button @click="mobileMenuOpen = true" class="text-white hover:text-primary transition-colors focus:outline-none">
            <span class="material-symbols-outlined text-[32px]">menu</span>
        </button>
    </div>
</header>