<!DOCTYPE html>

<html class="dark" lang="es"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>ModeloPlanet Home Desktop</title>
<!-- Fonts -->
<link href="https://fonts.googleapis.com" rel="preconnect"/>
<link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
<link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&amp;family=Noto+Sans:ital,wght@0,100..900;1,100..900&amp;display=swap" rel="stylesheet"/>
<!-- Icons -->
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap" rel="stylesheet"/>
<!-- Tailwind CSS -->
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<!-- Tailwind Config -->
<script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#ee2b5b",
                        "gold": "#D4AF37",
                        "gold-light": "#F3E5AB",
                        "background-light": "#f8f6f6",
                        "background-dark": "#181113", // Deep dark background from example
                        "surface-dark": "#271c1e",
                        "surface-border": "#39282c",
                    },
                    fontFamily: {
                        "display": ["Plus Jakarta Sans", "sans-serif"],
                        "body": ["Noto Sans", "sans-serif"],
                    },
                    borderRadius: {"DEFAULT": "0.25rem", "lg": "0.5rem", "xl": "0.75rem", "2xl": "1rem", "full": "9999px"},
                },
            },
        }
    </script>
<style>
        /* Custom scrollbar for a cleaner look */
        ::-webkit-scrollbar {
            width: 8px;
        }
        ::-webkit-scrollbar-track {
            background: #181113; 
        }
        ::-webkit-scrollbar-thumb {
            background: #39282c; 
            border-radius: 4px;
        }
        ::-webkit-scrollbar-thumb:hover {
            background: #ee2b5b; 
        }
        
        /* Pulse animation for 'Available' badge */
        @keyframes pulse-green {
            0% { box-shadow: 0 0 0 0 rgba(74, 222, 128, 0.7); }
            70% { box-shadow: 0 0 0 6px rgba(74, 222, 128, 0); }
            100% { box-shadow: 0 0 0 0 rgba(74, 222, 128, 0); }
        }
        .status-pulse {
            animation: pulse-green 2s infinite;
        }
    </style>
</head>
<body class="bg-background-light dark:bg-background-dark text-slate-900 dark:text-white font-display overflow-x-hidden selection:bg-primary selection:text-white">
<div class="relative flex min-h-screen w-full flex-col group/design-root">
<!-- Header -->
<header class="sticky top-0 z-50 flex items-center justify-between whitespace-nowrap border-b border-solid border-surface-border bg-background-dark/95 backdrop-blur-md px-6 lg:px-10 py-3 shadow-lg">
<div class="flex items-center gap-4 text-white">
<div class="size-8 text-primary">
<span class="material-symbols-outlined text-[32px]">diamond</span>
</div>
<h2 class="text-white text-xl font-bold leading-tight tracking-[-0.015em]">ModeloPlanet<span class="text-primary">.cl</span></h2>
</div>
<!-- Desktop Nav -->
<div class="hidden lg:flex flex-1 justify-end gap-8">
<nav class="flex items-center gap-9">
<a class="text-white hover:text-primary transition-colors text-sm font-medium leading-normal" href="#">Inicio</a>
<a class="text-gold hover:text-gold-light transition-colors text-sm font-bold leading-normal flex items-center gap-1" href="#">
<span class="material-symbols-outlined text-[18px] filled">star</span> VIP
                    </a>
<a class="text-white hover:text-primary transition-colors text-sm font-medium leading-normal" href="#">Casting</a>
<a class="text-white hover:text-primary transition-colors text-sm font-medium leading-normal" href="/login">Ingresar</a>
</nav>
<div class="flex gap-3">
<button class="flex cursor-pointer items-center justify-center overflow-hidden rounded-lg h-10 px-5 bg-primary hover:bg-primary/90 transition-all text-white text-sm font-bold shadow-[0_0_15px_rgba(238,43,91,0.4)]">
<span class="truncate">Publicar Anuncio</span>
</button>
<button class="flex size-10 cursor-pointer items-center justify-center overflow-hidden rounded-lg bg-surface-dark hover:bg-surface-border transition-colors text-white border border-surface-border">
<span class="material-symbols-outlined">favorite</span>
</button>
<button class="flex size-10 cursor-pointer items-center justify-center overflow-hidden rounded-lg bg-surface-dark hover:bg-surface-border transition-colors text-white border border-surface-border">
<span class="material-symbols-outlined">account_circle</span>
</button>
</div>
</div>
<!-- Mobile Menu Toggle -->
<div class="lg:hidden">
<button class="text-white">
<span class="material-symbols-outlined">menu</span>
</button>
</div>
</header>
<main class="flex-1 flex flex-col">
<!-- Hero Section -->
<div class="relative w-full h-[500px] lg:h-[600px] bg-background-dark overflow-hidden">
<!-- Background Image -->
<div class="absolute inset-0 w-full h-full bg-cover bg-center" data-alt="Elegant dark studio background with soft red and gold lighting" style="background-image: linear-gradient(to right, rgba(24, 17, 19, 1) 0%, rgba(24, 17, 19, 0.6) 50%, rgba(24, 17, 19, 0.2) 100%), url('https://lh3.googleusercontent.com/aida-public/AB6AXuABgaJX8BkZ7Xl2DLvSkEE3N8oJKP6szDq19u-jUwnbp4aqPKny-kE4r9FR5p_yXF3-g-THvgBEDYcJ-I3cdU5sG8bOLp7VT3iMN3OhR4rGTcJkBdPJ29sL7OJteHwiWELO2o38oVQlCgM8Ocw7uYhIYYt4nCYs6GwpcJTA3rv7Cd2pqv5-Ze1ZIPuf9-fxAyn9JtvyZUX-aErEl5MgcLJ8X-NvQS79xW2n434EjIYxCUWxyy936RyuPPxWtEq5jQzAH8Q2FnLeVph3');">
</div>
<div class="relative z-10 h-full max-w-[1440px] mx-auto px-6 lg:px-20 flex flex-col justify-center items-start pt-10">
<span class="inline-block px-3 py-1 rounded-full bg-primary/20 border border-primary/40 text-primary text-xs font-bold mb-4 tracking-wider uppercase">
                        La plataforma #1 en Chile
                    </span>
<h1 class="text-white text-5xl lg:text-7xl font-black leading-[1.1] tracking-tight max-w-3xl mb-6">
                        Modelos <span class="text-transparent bg-clip-text bg-gradient-to-r from-white to-gray-400">Verificadas</span><br/>
<span class="text-primary">En Tu Región.</span>
</h1>
<p class="text-gray-300 text-lg lg:text-xl font-normal max-w-xl mb-10 leading-relaxed">
                        Explora el directorio más exclusivo de modelos independientes. Seguridad, elegancia y compañía de alto nivel.
                    </p>
<div class="flex flex-wrap gap-4">
<button class="flex h-14 px-8 items-center justify-center rounded-lg bg-primary text-white text-base font-bold shadow-[0_0_20px_rgba(238,43,91,0.5)] hover:scale-105 transition-transform">
                            Ver Disponibles Ahora
                        </button>
<button class="flex h-14 px-8 items-center justify-center rounded-lg bg-surface-dark border border-surface-border text-white text-base font-bold hover:bg-surface-border transition-colors">
                            Explorar VIP
                        </button>
</div>
</div>
<!-- Decorative elements simulating slider dots -->
<div class="absolute bottom-8 left-1/2 -translate-x-1/2 flex gap-2">
<div class="w-8 h-1 bg-white rounded-full"></div>
<div class="w-2 h-1 bg-white/30 rounded-full"></div>
<div class="w-2 h-1 bg-white/30 rounded-full"></div>
</div>
</div>
<!-- Sticky Filters Bar -->
<div class="sticky top-[73px] z-40 bg-surface-dark/95 backdrop-blur border-b border-surface-border py-4 shadow-md">
<div class="max-w-[1440px] mx-auto px-6 lg:px-20 flex flex-col lg:flex-row gap-4 items-center justify-between">
<div class="flex items-center gap-2 text-white font-medium whitespace-nowrap">
<span class="material-symbols-outlined text-primary">filter_list</span>
                        Filtros Rápidos:
                    </div>
<div class="flex flex-1 w-full gap-3 overflow-x-auto pb-1 lg:pb-0 scrollbar-hide">
<!-- Select Region -->
<div class="relative min-w-[200px]">
<select class="w-full h-10 pl-4 pr-10 rounded-lg bg-background-dark border border-surface-border text-white text-sm focus:ring-1 focus:ring-primary focus:border-primary appearance-none cursor-pointer">
<option>Todas las Regiones</option>
<option>Metropolitana</option>
<option>Valparaíso</option>
<option>Biobío</option>
</select>
<span class="material-symbols-outlined absolute right-3 top-2.5 text-gray-400 pointer-events-none text-[20px]">expand_more</span>
</div>
<!-- Select Comuna -->
<div class="relative min-w-[200px]">
<select class="w-full h-10 pl-4 pr-10 rounded-lg bg-background-dark border border-surface-border text-white text-sm focus:ring-1 focus:ring-primary focus:border-primary appearance-none cursor-pointer">
<option>Todas las Comunas</option>
<option>Las Condes</option>
<option>Providencia</option>
<option>Santiago Centro</option>
<option>Vitacura</option>
</select>
<span class="material-symbols-outlined absolute right-3 top-2.5 text-gray-400 pointer-events-none text-[20px]">expand_more</span>
</div>
<!-- Select Category -->
<div class="relative min-w-[180px]">
<select class="w-full h-10 pl-4 pr-10 rounded-lg bg-background-dark border border-surface-border text-white text-sm focus:ring-1 focus:ring-primary focus:border-primary appearance-none cursor-pointer">
<option>Categoría</option>
<option>VIP</option>
<option>Nuevas</option>
<option>Verificadas</option>
</select>
<span class="material-symbols-outlined absolute right-3 top-2.5 text-gray-400 pointer-events-none text-[20px]">expand_more</span>
</div>
</div>
<div class="hidden lg:block w-px h-8 bg-surface-border mx-2"></div>
<!-- Search -->
<div class="relative w-full lg:w-auto min-w-[250px]">
<input class="w-full h-10 pl-10 pr-4 rounded-lg bg-background-dark border border-surface-border text-white text-sm focus:ring-1 focus:ring-primary focus:border-primary placeholder:text-gray-500" placeholder="Buscar por nombre..." type="text"/>
<span class="material-symbols-outlined absolute left-3 top-2.5 text-gray-500 text-[20px]">search</span>
</div>
</div>
</div>
<!-- Main Content Container -->
<div class="flex-1 max-w-[1440px] mx-auto w-full px-6 lg:px-20 py-8 space-y-16">
<!-- Section: Disponibles Ahora -->
<section>
<div class="flex items-end justify-between mb-6">
<div>
<div class="flex items-center gap-2 mb-1">
<h2 class="text-white text-2xl lg:text-3xl font-bold">Disponibles Ahora</h2>
<span class="relative flex h-3 w-3">
<span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-green-400 opacity-75"></span>
<span class="relative inline-flex rounded-full h-3 w-3 bg-green-500"></span>
</span>
</div>
<p class="text-gray-400 text-sm">Responden en menos de 5 minutos</p>
</div>
<a class="text-primary text-sm font-bold hover:underline" href="#">Ver todas</a>
</div>
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
    <?php foreach($disponibles as $modelo): ?>
    <div class="group relative flex flex-col bg-surface-dark rounded-xl overflow-hidden border border-surface-border hover:border-primary50">
        <div class="relative aspect-[3/4] overflow-hidden">
            <!-- Imagen placeholder o real -->
            <img src="<?= base_url('images/models/' . ($modelo['foto_principal'] ?? 'default.png')) ?>" 
                 alt="<?= esc($modelo['nombre']) ?>" 
                 class="w-full h-full object-cover group-hover:scale-105 transition-transform">
            
            <?php if($modelo['disponible'] ?? true): ?>
            <span class="absolute top-3 left-3 bg-green-500 text-white px-2 py-1 rounded text-xs font-bold flex items-center">
                <span class="w-1.5 h-1.5 bg-white rounded-full animate-pulse mr-1"></span>Online
            </span>
            <?php endif; ?>
            
            <button class="absolute top-3 right-3 w-8 h-8 rounded-full bg-black/40 backdrop-blur flex items-center justify-center hover:bg-primary">
                <span class="material-symbols-outlined text-white text-sm">favorite</span>
            </button>
        </div>
        
        <div class="p-4">
            <div class="flex items-center justify-between mb-1">
                <h3 class="text-white font-bold text-lg"><?= esc($modelo['nombre']) ?></h3>
                <?php if($modelo['vip']): ?>
                <span class="material-symbols-outlined text-yellow-400 text-xl">star</span>
                <?php endif; ?>
            </div>
            <p class="text-gray-400 text-sm mb-2"><?= esc($modelo['comuna']) ?></p>
            
            <!-- Servicios -->
            <div class="flex flex-wrap gap-1">
                <?php 
                $servs = json_decode($modelo['servicios'] ?? '[]', true);
                foreach($servs as $serv): 
                ?>
                <span class="px-2 py-0.5 bg-gray-800 text-xs rounded"><?= ucfirst($serv) ?></span>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    
    <?php if(empty($disponibles)): ?>
    <div class="col-span-full text-center py-12 text-gray-500">
        No hay modelos disponibles. ¡Sé el primero!
    </div>
    <?php endif; ?>
</div>
</section>
<!-- Section: VIP Exclusive -->
<section>
<div class="flex items-center justify-between mb-6">
<div>
<div class="flex items-center gap-2 mb-1">
<h2 class="text-gold text-2xl lg:text-3xl font-bold flex items-center gap-2">
<span class="material-symbols-outlined filled">workspace_premium</span> VIP Exclusivas
                                </h2>
</div>
<p class="text-gray-400 text-sm">Las perfiles más destacados y solicitados.</p>
</div>
<a class="text-gold text-sm font-bold hover:underline" href="#">Ver directorio VIP</a>
</div>
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
<!-- VIP Card 1 -->
<div class="group relative flex flex-col bg-[#1A1A1A] rounded-xl overflow-hidden border border-gold/40 hover:border-gold transition-all shadow-[0_0_15px_rgba(212,175,55,0.1)] hover:shadow-[0_0_25px_rgba(212,175,55,0.3)]">
<div class="relative h-64 overflow-hidden">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-700 group-hover:scale-105" data-alt="Elegant VIP model posing in evening gown" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuDmtVhU-0GfwYWux8id98TUz7dGS3DnsTa9kQ03pH-Q_Yzu2w5-cW6scEMF4XyNZRpM3cAnh7T-YVYYXf13kZ0QWV79YEKU0_-qggACaBQqsHlvEO3gDMhMpFkrNcZkV0oKBjWo-wWj1e7r6zbH8vV_Bshul1Tu4qlrh3htynMzmeuJZukxGbiMv-pe_EBy5uCmj8FJVm0AwZYh1vzm0uycGwMWvFlssBQV8DWQnWhN2BWUkP0wp59l-3-g2Y5FQqLF2Zj7UwZdJOxI');">
</div>
<div class="absolute top-0 right-0 p-3">
<div class="bg-gold text-black text-xs font-black px-2 py-1 rounded uppercase tracking-wider">
                                        Premium
                                    </div>
</div>
</div>
<div class="p-5 flex flex-col gap-2 bg-gradient-to-b from-[#1A1A1A] to-black">
<div class="flex justify-between items-start">
<div>
<h3 class="text-white text-xl font-bold">Antonia VIP</h3>
<p class="text-gold text-sm font-medium">Viña del Mar</p>
</div>
<span class="material-symbols-outlined text-gold filled text-[24px]">star</span>
</div>
<p class="text-gray-400 text-sm line-clamp-2">Experiencia de lujo garantizada. Atención personalizada para eventos de alto nivel.</p>
<button class="mt-2 w-full py-2 rounded border border-gold text-gold font-bold text-sm hover:bg-gold hover:text-black transition-colors">
                                    Ver Perfil Completo
                                </button>
</div>
</div>
<!-- VIP Card 2 -->
<div class="group relative flex flex-col bg-[#1A1A1A] rounded-xl overflow-hidden border border-gold/40 hover:border-gold transition-all shadow-[0_0_15px_rgba(212,175,55,0.1)] hover:shadow-[0_0_25px_rgba(212,175,55,0.3)]">
<div class="relative h-64 overflow-hidden">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-700 group-hover:scale-105" data-alt="Model with luxurious jewelry and styling" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuCaNWCoqNQyPI20BLUE6xsBnq7Q3AH_yQKAfRv5KTsH2MKJwgO3eaqt0CH5MmqcYbpt-PwpfaiMrk8jdAl5nFknX3XGrteOn6rOvTRShtEy73213pygkE3216ucpuqVnyk_JeJ1EWedgyyfjWrpKpCZAbdJN2PJcznLYbaWYw2Nc44siKUIpJ7WcyFT75urekCZafZsH4Sg5Qx-aQV15MVkxTPwciQKaHTh2w7aZ11rq68pkGpC9MvW6zfSoK4gODSFkV6OziIlE7BV');">
</div>
<div class="absolute top-0 right-0 p-3">
<div class="bg-gold text-black text-xs font-black px-2 py-1 rounded uppercase tracking-wider">
                                        Premium
                                    </div>
</div>
</div>
<div class="p-5 flex flex-col gap-2 bg-gradient-to-b from-[#1A1A1A] to-black">
<div class="flex justify-between items-start">
<div>
<h3 class="text-white text-xl font-bold">Martina VIP</h3>
<p class="text-gold text-sm font-medium">Las Condes</p>
</div>
<span class="material-symbols-outlined text-gold filled text-[24px]">star</span>
</div>
<p class="text-gray-400 text-sm line-clamp-2">Elegancia y discreción absoluta. Disponibilidad limitada.</p>
<button class="mt-2 w-full py-2 rounded border border-gold text-gold font-bold text-sm hover:bg-gold hover:text-black transition-colors">
                                    Ver Perfil Completo
                                </button>
</div>
</div>
<!-- VIP Card 3 -->
<div class="group relative flex flex-col bg-[#1A1A1A] rounded-xl overflow-hidden border border-gold/40 hover:border-gold transition-all shadow-[0_0_15px_rgba(212,175,55,0.1)] hover:shadow-[0_0_25px_rgba(212,175,55,0.3)]">
<div class="relative h-64 overflow-hidden">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-700 group-hover:scale-105" data-alt="Sophisticated model with classic fashion" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuDutB9-id2OLAB7PTU2rKJA5r7Eed8kcZLyV9-8v2hyJIq8RLLeS3Nc2R30DV7ClfsYwUUOuvf6sVfa5NyaVdydnxYOlf_CTw0rDyIoYJLST2YMdCvyS7gN20Y9NvY8Ez046rhhp0h2R0lcszYRtw3uRHIOthKe3SNPdn523F_xcmx3t4DVyH3de1y6STLMy-s6ncaEUDNqSt4w70MCpaC4YcFRbTzSVrAtyw1B7ruM6xe_ti5UOVuCR-DmkepmKs7R4WZy23NHgxoY');">
</div>
<div class="absolute top-0 right-0 p-3">
<div class="bg-gold text-black text-xs font-black px-2 py-1 rounded uppercase tracking-wider">
                                        Premium
                                    </div>
</div>
</div>
<div class="p-5 flex flex-col gap-2 bg-gradient-to-b from-[#1A1A1A] to-black">
<div class="flex justify-between items-start">
<div>
<h3 class="text-white text-xl font-bold">Fernanda VIP</h3>
<p class="text-gold text-sm font-medium">Lo Barnechea</p>
</div>
<span class="material-symbols-outlined text-gold filled text-[24px]">star</span>
</div>
<p class="text-gray-400 text-sm line-clamp-2">La mejor compañía para tus cenas de negocios y eventos sociales.</p>
<button class="mt-2 w-full py-2 rounded border border-gold text-gold font-bold text-sm hover:bg-gold hover:text-black transition-colors">
                                    Ver Perfil Completo
                                </button>
</div>
</div>
</div>
</section>
<!-- Section: New Arrivals (Simple List) -->
<section>
<div class="flex items-center justify-between mb-6">
<h2 class="text-white text-2xl lg:text-3xl font-bold">Novedades de la Semana</h2>
<a class="text-primary text-sm font-bold hover:underline" href="#">Ver todas las nuevas</a>
</div>
<div class="flex overflow-x-auto gap-4 pb-4 snap-x">
<!-- New Card 1 -->
<div class="snap-start min-w-[200px] w-[200px] flex flex-col gap-2 group cursor-pointer">
<div class="relative h-[250px] rounded-lg overflow-hidden bg-surface-dark">
<div class="absolute top-2 left-2 z-10 bg-primary text-white text-[10px] font-bold px-2 py-0.5 rounded">NUEVA</div>
<img class="w-full h-full object-cover transition-transform group-hover:scale-110 duration-500" data-alt="New model portrait" src="https://lh3.googleusercontent.com/aida-public/AB6AXuC7Bw3YRFj8RUgMpUcANNg8PpJ79WhU24O_saC6QJS5A9lr18sST6LJH5mPaWfyEVAAyXDTc0yILSmZD2bA3aBDcXNUH8lSvz_TbPssXXxOXQCG5Ix_NrAEyay_26e8AIIoi-jlPwEfgUSmG8Iheu5iC6vlQmQ9ILAElAyf7TYXacjvmbf31XgVI4cZP0EkwpnEKEySzsZpstWi9jjvJcwMYCA3Z44sDt6D9kjoBmaqSy30YB1kVbv1FDkBGesIzbYoi0WJIBaK7LeE"/>
</div>
<div>
<h4 class="text-white font-bold">Dani, 19</h4>
<p class="text-gray-500 text-xs">Santiago Centro</p>
</div>
</div>
<!-- New Card 2 -->
<div class="snap-start min-w-[200px] w-[200px] flex flex-col gap-2 group cursor-pointer">
<div class="relative h-[250px] rounded-lg overflow-hidden bg-surface-dark">
<div class="absolute top-2 left-2 z-10 bg-primary text-white text-[10px] font-bold px-2 py-0.5 rounded">NUEVA</div>
<img class="w-full h-full object-cover transition-transform group-hover:scale-110 duration-500" data-alt="Smiling new model" src="https://lh3.googleusercontent.com/aida-public/AB6AXuDchVAXUhO1S0v10FFIdDB2hJw5HBQDnAYqDbfRGyShYjlUTZUHTd-9fv-JwueMD9i4jKmy7OVb0dvhZ4tDpkiWdgVjTdAbleT7uYHvgcpwMjwMfKx4rB3sGvmtqhV3h7WHE9yiKf1V7-6uFo-2yVRBvuJ5YVv9YSLqmH3uvv-YluDjrx3YYlOJnXkIYQLM6R7XeWA-fgs1y84hIQf_NRZR7OD9_xm2LTJfqFysBKr9O1swo5JfnY3WFRgqNGePafeCOCGj7SZT72_U"/>
</div>
<div>
<h4 class="text-white font-bold">Rocío, 22</h4>
<p class="text-gray-500 text-xs">Ñuñoa</p>
</div>
</div>
<!-- New Card 3 -->
<div class="snap-start min-w-[200px] w-[200px] flex flex-col gap-2 group cursor-pointer">
<div class="relative h-[250px] rounded-lg overflow-hidden bg-surface-dark">
<div class="absolute top-2 left-2 z-10 bg-primary text-white text-[10px] font-bold px-2 py-0.5 rounded">NUEVA</div>
<img class="w-full h-full object-cover transition-transform group-hover:scale-110 duration-500" data-alt="New model outdoors" src="https://lh3.googleusercontent.com/aida-public/AB6AXuBx3E6j5ZZ6vDjpZExyPIZfJ1FWFGtFzWmO2oRVuydFgnhGDQC_SVrZnLqMHDugarAurMZUiT-XHz4mjqoobxeQ568_T4mFQyUvQ8D3eTT4Fx0dKsmX4KpdCaykSyLjwxRhVV5lYKJgPPw2rXSO7oS1v88bybiTMJoJQyY8MCLBSRBO0XpJwjslbNa_UwEOHIQGfO-VyM37_Gh7uF5hzFB2j63YAF1d-PJiCVTBN2v2CIsi1pOGpelXD70fAnLIqr50Cn--C7SXW2Ux"/>
</div>
<div>
<h4 class="text-white font-bold">Mila, 20</h4>
<p class="text-gray-500 text-xs">La Florida</p>
</div>
</div>
<!-- New Card 4 -->
<div class="snap-start min-w-[200px] w-[200px] flex flex-col gap-2 group cursor-pointer">
<div class="relative h-[250px] rounded-lg overflow-hidden bg-surface-dark">
<div class="absolute top-2 left-2 z-10 bg-primary text-white text-[10px] font-bold px-2 py-0.5 rounded">NUEVA</div>
<img class="w-full h-full object-cover transition-transform group-hover:scale-110 duration-500" data-alt="New model looking stylish" src="https://lh3.googleusercontent.com/aida-public/AB6AXuBOO8ET6i3FhFgUsQTI8X5pP-XSLVgcaxzMIcP32lSJZsCR_zizyNzTlMUpYR1YFOnATC-dklWkaJDRHSPDJZgVZZC58xvtTZCXzztDWALmMfYi2Op5VABuw_vdyF9Lly_vJBoSUr_LSg7suBnCN9ME0PKM_6cNimoK9BzSgiZdvXNJC8--_1OVQyiesxmJjYCTTA7BWYVCceTxiY8FuT5qtf9BNiUBdiLixDDeNbTZXfUYVz8Nbn-dX39WuOR48OoUjVqKRWUFzVmV"/>
</div>
<div>
<h4 class="text-white font-bold">Vicky, 26</h4>
<p class="text-gray-500 text-xs">Las Condes</p>
</div>
</div>
</div>
</section>
</div>
<!-- Big CTA -->
<section class="w-full py-20 bg-surface-dark border-y border-surface-border">
<div class="max-w-4xl mx-auto px-6 text-center">
<h2 class="text-3xl lg:text-5xl font-black text-white mb-6">
                        ¿Buscas compañía en otra región?
                    </h2>
<p class="text-gray-400 text-lg mb-8 max-w-2xl mx-auto">
                        ModeloPlanet cuenta con la red más grande de modelos verificadas en todo Chile. Desde Arica a Punta Arenas.
                    </p>
<button class="px-8 py-4 bg-white text-black font-bold rounded-lg text-lg hover:bg-gray-200 transition-colors shadow-[0_0_20px_rgba(255,255,255,0.2)]">
                        Explora Modelos en Todo Chile
                    </button>
</div>
</section>
</main>
<!-- Footer -->
<footer class="bg-background-dark border-t border-surface-border pt-16 pb-8 px-6 lg:px-20">
<div class="max-w-[1440px] mx-auto grid grid-cols-1 md:grid-cols-4 gap-10 mb-12">
<div class="col-span-1 md:col-span-1">
<div class="flex items-center gap-2 text-white mb-4">
<span class="material-symbols-outlined text-primary text-[24px]">diamond</span>
<h2 class="text-lg font-bold">ModeloPlanet</h2>
</div>
<p class="text-gray-500 text-sm mb-4">La plataforma líder en anuncios de modelos independientes en Chile. Seguridad y confianza garantizada.</p>
<div class="flex gap-4">
<a class="text-gray-400 hover:text-white" href="#"><span class="material-symbols-outlined">public</span></a>
<a class="text-gray-400 hover:text-white" href="#"><span class="material-symbols-outlined">mail</span></a>
</div>
</div>
<div>
<h3 class="text-white font-bold mb-4">Plataforma</h3>
<ul class="space-y-2 text-gray-500 text-sm">
<li><a class="hover:text-primary" href="#">Inicio</a></li>
<li><a class="hover:text-primary" href="#">Novedades</a></li>
<li><a class="hover:text-primary" href="#">Ranking Top 30</a></li>
<li><a class="hover:text-primary" href="#">Categoría VIP</a></li>
</ul>
</div>
<div>
<h3 class="text-white font-bold mb-4">Soporte</h3>
<ul class="space-y-2 text-gray-500 text-sm">
<li><a class="hover:text-primary" href="#">Centro de Ayuda</a></li>
<li><a class="hover:text-primary" href="#">Publicar Aviso</a></li>
<li><a class="hover:text-primary" href="#">Reportar Problema</a></li>
<li><a class="hover:text-primary" href="#">Contacto</a></li>
</ul>
</div>
<div>
<h3 class="text-white font-bold mb-4">Legal</h3>
<ul class="space-y-2 text-gray-500 text-sm">
<li><a class="hover:text-primary" href="#">Términos y Condiciones</a></li>
<li><a class="hover:text-primary" href="#">Privacidad</a></li>
<li><a class="hover:text-primary" href="#">Política de Cookies</a></li>
</ul>
</div>
</div>
<div class="max-w-[1440px] mx-auto border-t border-surface-border pt-8 flex flex-col md:flex-row justify-between items-center gap-4">
<p class="text-gray-600 text-xs">© 2024 ModeloPlanet. Todos los derechos reservados.</p>
<div class="bg-surface-dark px-3 py-1 rounded border border-surface-border">
<p class="text-gray-400 text-xs font-bold flex items-center gap-1">
<span class="text-primary text-sm">18+</span> Contenido para adultos
                    </p>
</div>
</div>
</footer>
</div>
</body></html>