<!DOCTYPE html>
<html class="dark" lang="es">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title>Registro - Calientitas</title>
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;700;800&display=swap" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap" rel="stylesheet"/>
    <script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#ee2b5b",
                        "background-dark": "#120d0f",
                        "surface-dark": "#181113",
                        "border-dark": "#39282c",
                        "text-secondary": "#a1a1aa"
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-background-dark text-white font-sans antialiased min-h-screen flex flex-col">
<header class="flex items-center justify-between px-6 py-4 border-b border-border-dark bg-surface-dark/50 backdrop-blur-sm sticky top-0 z-50">
    <a href="<?= base_url('/') ?>" class="flex items-center gap-2">
        <span class="material-symbols-outlined text-primary">local_fire_department</span>
        <span class="text-sm font-black uppercase italic tracking-tighter">Calientitas</span>
    </a>
    <a href="<?= base_url('/') ?>" class="flex items-center gap-2 text-[10px] font-black uppercase tracking-widest text-primary hover:text-white transition-all px-3 py-2 rounded-full border border-primary/20">
        <span class="material-symbols-outlined text-sm">home</span>
        <span>Volver</span>
    </a>
</header>
<div class="flex-1 flex items-center justify-center p-6">
    <div class="w-full max-w-[480px] bg-surface-dark border border-border-dark rounded-2xl overflow-hidden shadow-2xl">
        <div class="p-8 sm:p-12">
            <div class="text-center mb-8">
                <h1 class="text-3xl font-extrabold tracking-tight mb-2 uppercase italic">Crear cuenta</h1>
                <p class="text-text-secondary text-sm">Únete a la red más exclusiva de Chile.</p>
            </div>

            <?php if (session()->getFlashdata('error')): ?>
                <div class="bg-red-500/10 border border-red-500/50 text-red-500 p-4 rounded-xl text-xs mb-6 flex items-center gap-3">
                    <span class="material-symbols-outlined text-sm">error</span>
                    <?= session()->getFlashdata('error') ?>
                </div>
            <?php endif; ?>

            <form action="<?= base_url('registro/registrar') ?>" method="post" class="space-y-5" id="registerForm">
                <?= csrf_field() ?>

                <div class="hidden">
                    <input type="text" name="hp_field" value="">
                </div>

                <div class="flex flex-col gap-2">
                    <label class="text-[10px] text-text-secondary font-bold uppercase tracking-widest">¿Cómo quieres unirte?</label>
                    <div class="grid grid-cols-2 gap-3">
                        <label class="cursor-pointer">
                            <input type="radio" name="rol" value="modelo" class="hidden peer" checked>
                            <div class="py-3 border border-border-dark rounded-xl text-center peer-checked:border-primary peer-checked:bg-primary/10 transition-all">
                                <span class="text-sm font-bold opacity-60 peer-checked:opacity-100">Soy Modelo</span>
                            </div>
                        </label>
                        <label class="cursor-pointer">
                            <input type="radio" name="rol" value="usuario" class="hidden peer">
                            <div class="py-3 border border-border-dark rounded-xl text-center peer-checked:border-primary peer-checked:bg-primary/10 transition-all">
                                <span class="text-sm font-bold opacity-60 peer-checked:opacity-100">Soy Público</span>
                            </div>
                        </label>
                    </div>
                </div>

                <div class="flex flex-col gap-1.5">
                    <label class="text-[10px] text-text-secondary font-bold uppercase tracking-widest">Nombre Completo</label>
                    <input name="nombre" type="text" value="<?= old('nombre') ?>" placeholder="Ej: Valentina Paz" required
                           class="w-full h-12 bg-background-dark border border-border-dark rounded-xl px-4 text-sm focus:border-primary focus:ring-0 outline-none transition-all">
                </div>

                <div class="flex flex-col gap-1.5">
                    <label class="text-[10px] text-text-secondary font-bold uppercase tracking-widest">Email</label>
                    <input name="email" type="email" value="<?= old('email') ?>" placeholder="tu@email.com" required
                           class="w-full h-12 bg-background-dark border border-border-dark rounded-xl px-4 text-sm focus:border-primary focus:ring-0 outline-none transition-all">
                </div>

                <div class="flex flex-col gap-1.5">
                    <label class="text-[10px] text-text-secondary font-bold uppercase tracking-widest">Contraseña (Mín. 6 caracteres)</label>
                    <div class="relative">
                        <input id="password" name="password" type="password" placeholder="••••••••" required minlength="6"
                               class="w-full h-12 bg-background-dark border border-border-dark rounded-xl px-4 pr-12 text-sm focus:border-primary focus:ring-0 outline-none transition-all">
                        <button type="button" onclick="togglePass('password')" class="absolute right-4 top-1/2 -translate-y-1/2 text-text-secondary hover:text-white transition-colors">
                            <span class="material-symbols-outlined text-[20px]">visibility</span>
                        </button>
                    </div>
                </div>

                <div class="flex flex-col gap-1.5">
                    <label class="text-[10px] text-text-secondary font-bold uppercase tracking-widest">Confirmar Contraseña</label>
                    <input id="pass_confirm" name="pass_confirm" type="password" placeholder="••••••••" required
                           class="w-full h-12 bg-background-dark border border-border-dark rounded-xl px-4 text-sm focus:border-primary focus:ring-0 outline-none transition-all">
                </div>

                <div class="flex items-start gap-3 pt-2">
                    <input type="checkbox" id="terms" required class="mt-1 rounded border-border-dark bg-background-dark text-primary focus:ring-offset-background-dark focus:ring-primary">
                    <label for="terms" class="text-[11px] text-text-secondary leading-tight">
                        Confirmo que soy <span class="text-white font-bold">mayor de 18 años</span> y acepto los <a href="#" class="underline hover:text-primary transition-colors">términos de servicio</a>.
                    </label>
                </div>

                <button type="submit" class="w-full h-14 bg-primary hover:bg-primary/90 text-white font-black rounded-xl shadow-lg shadow-primary/20 transition-all mt-4 uppercase tracking-widest text-sm active:scale-[0.98]">
                    Registrarme ahora
                </button>
            </form>

            <div class="text-center mt-8">
                <p class="text-sm text-text-secondary font-medium">
                    ¿Ya tienes una cuenta? 
                    <a class="text-white font-bold hover:text-primary transition-colors ml-1 border-b border-white/20 hover:border-primary" href="<?= base_url('login') ?>">Inicia Sesión</a>
                </p>
            </div>
        </div>
    </div>
</div>

<footer class="p-6 text-center border-t border-border-dark opacity-40">
    <p class="text-[10px] text-text-secondary uppercase tracking-[3px]">&copy; 2026 Calientitas Chile</p>
</footer>

<script>
    // Función para ver/ocultar contraseña
    function togglePass(id) {
        const input = document.getElementById(id);
        const icon = event.currentTarget.querySelector('span');
        if (input.type === "password") {
            input.type = "text";
            icon.innerText = "visibility_off";
        } else {
            input.type = "password";
            icon.innerText = "visibility";
        }
    }

    // Validación de coincidencia de contraseñas en tiempo real
    const password = document.getElementById("password");
    const confirm_password = document.getElementById("pass_confirm");

    function validatePassword(){
        if(password.value != confirm_password.value) {
            confirm_password.setCustomValidity("Las contraseñas no coinciden");
        } else {
            confirm_password.setCustomValidity('');
        }
    }

    password.onchange = validatePassword;
    confirm_password.onkeyup = validatePassword;
</script>

</body>
</html>