<?= $this->extend('layouts/home_layout') ?>

<?= $this->section('content') ?>
<div class="flex flex-1 items-center justify-center p-6 min-h-[80vh]">
    <div class="w-full max-w-[440px] bg-surface-dark border border-border-dark p-8 rounded-3xl shadow-2xl">
        
        <div class="text-center mb-8">
            <h1 class="text-2xl font-black uppercase italic text-white leading-tight">&iquest;Olvidaste tu clave?</h1>
            <p class="text-gray-500 text-sm mt-2 font-medium">Ingresa tu correo para enviarte el enlace.</p>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="mb-6 p-4 text-emerald-400 border border-emerald-500/30 rounded-2xl bg-emerald-500/10 flex items-center gap-3 animate-alert">
                <span class="material-symbols-outlined">check_circle</span>
                <p class="text-[11px] font-bold uppercase tracking-tight"><?= session()->getFlashdata('success') ?></p>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="mb-6 p-4 text-primary border border-primary/30 rounded-2xl bg-primary/10 flex items-center gap-3 animate-alert">
                <span class="material-symbols-outlined">error</span>
                <p class="text-[11px] font-bold uppercase tracking-tight"><?= session()->getFlashdata('error') ?></p>
            </div>
        <?php endif; ?>

        <form action="<?= base_url('auth/enviar-token') ?>" method="POST" class="space-y-6">
            <?= csrf_field() ?>
            <div class="flex flex-col gap-2">
                <label class="text-[10px] font-black uppercase tracking-widest text-gray-400 ml-1">Tu Correo Electr&oacute;nico</label>
                <input type="email" name="email" required placeholder="ejemplo@correo.cl" 
                       class="w-full h-14 bg-background-dark border border-border-dark rounded-2xl px-5 text-sm text-white focus:border-primary outline-none transition-all">
            </div>
            
            <button type="submit" class="w-full h-14 bg-primary hover:bg-primary/90 text-white font-black rounded-2xl shadow-lg shadow-primary/20 uppercase tracking-widest text-sm transition-all active:scale-95">
                Enviar Enlace
            </button>
        </form>

        <div class="mt-8 text-center">
            <a href="<?= base_url('login') ?>" class="text-xs font-bold text-gray-500 hover:text-white transition-colors uppercase tracking-widest flex items-center justify-center gap-2">
                <span class="material-symbols-outlined text-sm">arrow_back</span> Volver al Login
            </a>
        </div>
    </div>
</div>
<?= $this->endSection() ?>