<!DOCTYPE html>
<html class="dark" lang="es">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title><?= $titulo ?> - Calientitas</title>
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght@100..700,0..1&display=swap" rel="stylesheet"/>
    <script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#ee2b5b",
                        "gold": "#d4af37",
                        "background-light": "#f8f6f6",
                        "background-dark": "#0f080a",
                        "card-dark": "#1a0f12",
                        "border-dark": "#2d1b20",
                    },
                    fontFamily: {
                        "display": ["Plus Jakarta Sans", "sans-serif"]
                    },
                    borderRadius: { "DEFAULT": "0.25rem", "lg": "0.5rem", "xl": "0.75rem", "full": "9999px" },
                },
            },
        }
    </script>
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
        .material-symbols-outlined { font-variation-settings: 'FILL' 0, 'wght' 400, 'GRAD' 0, 'opsz' 24; }
        .filled-icon { font-variation-settings: 'FILL' 1; }
        .gold-gradient { background: linear-gradient(135deg, #d4af37 0%, #f9e29c 50%, #b8860b 100%); }
    </style>
</head>
<body class="bg-background-light dark:bg-background-dark text-slate-900 dark:text-slate-100 min-h-screen flex">

<aside class="w-72 border-r border-slate-200 dark:border-border-dark flex flex-col h-screen sticky top-0 bg-white dark:bg-card-dark shrink-0">
    <div class="p-6 flex items-center gap-3">
        <div class="size-10 rounded-xl bg-primary flex items-center justify-center text-white shadow-lg shadow-primary/20">
            <span class="material-symbols-outlined filled-icon">diamond</span>
        </div>
        <div>
            <h1 class="text-lg font-bold leading-none tracking-tight">Calientitas</h1>
            <p class="text-xs text-slate-500 dark:text-slate-400 mt-1">Admin CMS Chile</p>
        </div>
    </div>
    <nav class="flex-1 px-4 py-4 space-y-1 overflow-y-auto">
        <a href="<?= base_url('admin/dashboard') ?>" class="flex items-center gap-3 px-3 py-2.5 rounded-lg bg-primary text-white font-medium">
                <span class="material-symbols-outlined">dashboard</span> Dashboard
            </a>
        <a class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-slate-600 dark:text-slate-400 hover:bg-slate-100 dark:hover:bg-white/5 transition-colors" href="#">
            <span class="material-symbols-outlined">group</span>Gestion de Modelos
        </a>
        <a href="<?= base_url('admin/resenas') ?>" class="flex items-center gap-3 p-3 rounded-xl hover:bg-white/5 transition-all text-text-muted">
            <span class="material-symbols-outlined">reviews</span>
            <span class="font-bold">Reseñas</span>
        </a>
        <a href="<?= base_url('admin/verificaciones') ?>" class="flex items-center gap-3 p-3 rounded-xl hover:bg-white/5 transition-all text-text-muted">
            <span class="material-symbols-outlined">verified_user</span>
            <span class="font-bold">Verificaciones</span>
            <span class="ml-auto bg-primary text-[10px] px-2 py-0.5 rounded-full text-white">Pendientes</span>
        </a>
        <a class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-slate-600 dark:text-slate-400 hover:bg-slate-100 dark:hover:bg-white/5 transition-colors" href="<?= base_url('admin/cambiar-password') ?>">
            <span class="material-symbols-outlined">lock</span>
            <span>Seguridad</span>
        </a>
    </nav>

    <div class="p-4 border-t border-slate-200 dark:border-border-dark">
        <div class="flex items-center gap-3 p-2 rounded-xl bg-slate-50 dark:bg-white/5">
            <div class="size-10 rounded-full bg-primary flex items-center justify-center text-white font-bold">
                <?= substr($usuario, 0, 1) ?>
            </div>
            <div class="flex-1 overflow-hidden">
                <p class="text-sm font-semibold truncate"><?= $usuario ?></p>
            </div>
            <a href="<?= base_url('logout') ?>" class="text-slate-400 hover:text-primary">
                <span class="material-symbols-outlined">logout</span>
            </a>
        </div>
    </div>
</aside>

<main class="flex-1 flex flex-col min-w-0">
   <?= $this->extend('layouts/admin_layout') ?>
<?= $this->section('content') ?>

<main class="flex-1 overflow-y-auto p-10 bg-background-dark">
    <h2 class="text-white text-3xl font-black mb-8 tracking-tight">Gestión de Planes</h2>

    <div class="bg-surface-dark rounded-3xl border border-border-dark overflow-hidden">
        <table class="w-full text-left border-collapse">
            <thead>
                <tr class="bg-black/20 text-[10px] uppercase tracking-widest text-text-muted border-b border-border-dark">
                    <th class="p-4">Modelo</th>
                    <th class="p-4">Estado Actual</th>
                    <th class="p-4">Vencimiento</th>
                    <th class="p-4">Acciones de Activación</th>
                </tr>
            </thead>
            <tbody class="text-white text-xs">
                <?php foreach($modelos as $m): ?>
                <tr class="border-b border-white/5 hover:bg-white/5 transition-colors">
                    <td class="p-4 flex items-center gap-3">
                        <img src="<?= base_url('uploads/modelos/'.$m['foto_principal']) ?>" class="size-10 rounded-lg object-cover">
                        <div>
                            <p class="font-bold"><?= $m['nombre_artistico'] ?></p>
                            <p class="text-[10px] text-text-muted uppercase"><?= $m['categoria'] ?></p>
                        </div>
                    </td>
                    <td class="p-4">
                        <?php 
                            $vencido = empty($m['plan_expiracion']) || strtotime($m['plan_expiracion']) < time();
                        ?>
                        <?php if($vencido): ?>
                            <span class="bg-red-500/10 text-red-500 px-2 py-1 rounded-md text-[9px] font-bold uppercase">Inactivo / Vencido</span>
                        <?php else: ?>
                            <span class="bg-emerald-500/10 text-emerald-500 px-2 py-1 rounded-md text-[9px] font-bold uppercase">Activo: <?= $m['membresia'] ?></span>
                        <?php endif; ?>
                    </td>
                    <td class="p-4 text-text-muted">
                        <?= $m['plan_expiracion'] ? date('d/m/Y H:i', strtotime($m['plan_expiracion'])) : 'Sin plan' ?>
                    </td>
                    <td class="p-4">
                        <form action="<?= base_url('admin/activar-plan/'.$m['id']) ?>" method="POST" class="flex items-center gap-2">
                            <?= csrf_field() ?>
                            <select name="membresia" class="bg-black/40 border border-border-dark rounded-lg px-2 py-1 text-[10px] outline-none">
                                <option value="normal">Normal</option>
                                <option value="premium">Premium</option>
                                <option value="vip">VIP</option>
                            </select>
                            <select name="dias" class="bg-black/40 border border-border-dark rounded-lg px-2 py-1 text-[10px] outline-none">
                                <option value="7">7 Días</option>
                                <option value="15">15 Días</option>
                                <option value="30" selected>30 Días</option>
                            </select>
                            <button type="submit" class="bg-gold text-black px-3 py-1 rounded-lg font-black text-[9px] uppercase hover:brightness-110">
                                Activar
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</main>

<?= $this->endSection() ?>
</main>

</body>
</html>