<?= $this->extend('layouts/admin_layout') ?>

<?= $this->section('content') ?>
<div class="p-8 space-y-8">
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 bg-surface-dark p-8 rounded-3xl border border-border-dark shadow-2xl">
        <div>
            <h1 class="text-3xl font-black text-white uppercase tracking-tighter">Resumen General</h1>
            <p class="text-gray-500 text-sm italic">Estado actual de la plataforma Calientitas.</p>
        </div>
        <div class="flex items-center gap-4">
             <div class="text-right">
                <p class="text-gray-500 text-[10px] font-bold uppercase tracking-widest">Sistema</p>
                <p class="text-emerald-500 text-sm font-black flex items-center gap-2">
                    <span class="size-2 bg-emerald-500 rounded-full animate-pulse"></span> OPERATIVO
                </p>
            </div>
        </div>
    </div>

    <section class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <div class="bg-surface-dark border border-border-dark p-6 rounded-2xl flex flex-col gap-4 group hover:border-primary/50 transition-all">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-[10px] font-black text-gray-500 uppercase tracking-widest">Total Modelos</p>
                    <h3 class="text-3xl font-black mt-1 text-white italic"><?= $stats['modelos'] ?></h3>
                </div>
                <div class="p-3 rounded-xl bg-primary/10 text-primary">
                    <span class="material-symbols-outlined font-variation-settings: 'FILL' 1">group</span>
                </div>
            </div>
            <a href="<?= base_url('admin/modelos') ?>" class="text-[10px] font-bold text-primary flex items-center gap-1 hover:underline">GESTIONAR MODELOS <span class="material-symbols-outlined text-xs">arrow_forward</span></a>
        </div>

        <div class="bg-surface-dark border border-border-dark p-6 rounded-2xl flex flex-col gap-4 group hover:border-gold/50 transition-all">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-[10px] font-black text-gray-500 uppercase tracking-widest">Pendientes Verificaci&oacute;n</p>
                    <h3 class="text-3xl font-black mt-1 text-white italic"><?= $stats['verificaciones'] ?></h3>
                </div>
                <div class="p-3 rounded-xl bg-gold/10 text-gold">
                    <span class="material-symbols-outlined font-variation-settings: 'FILL' 1">verified_user</span>
                </div>
            </div>
            <a href="<?= base_url('admin/verificaciones') ?>" class="text-[10px] font-bold text-gold flex items-center gap-1 hover:underline">REVISAR DOCUMENTOS <span class="material-symbols-outlined text-xs">arrow_forward</span></a>
        </div>

        <div class="bg-surface-dark border border-border-dark p-6 rounded-2xl flex flex-col gap-4 group hover:border-blue-500/50 transition-all">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-[10px] font-black text-gray-500 uppercase tracking-widest">Rese&ntilde;as por Aprobar</p>
                    <h3 class="text-3xl font-black mt-1 text-white italic"><?= $stats['resenas'] ?></h3>
                </div>
                <div class="p-3 rounded-xl bg-blue-500/10 text-blue-500">
                    <span class="material-symbols-outlined font-variation-settings: 'FILL' 1">reviews</span>
                </div>
            </div>
            <a href="<?= base_url('admin/resenas') ?>" class="text-[10px] font-bold text-blue-500 flex items-center gap-1 hover:underline">MODERAR RESE&Ntilde;AS <span class="material-symbols-outlined text-xs">arrow_forward</span></a>
        </div>

        <div class="bg-surface-dark border border-border-dark p-6 rounded-2xl flex flex-col gap-4 group hover:border-emerald-500/50 transition-all">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-[10px] font-black text-gray-500 uppercase tracking-widest">Clics WhatsApp Hoy</p>
                    <h3 class="text-3xl font-black mt-1 text-white italic"><?= $stats['clics'] ?></h3>
                </div>
                <div class="p-3 rounded-xl bg-emerald-500/10 text-emerald-500">
                    <span class="material-symbols-outlined font-variation-settings: 'FILL' 1">ads_click</span>
                </div>
            </div>
            <p class="text-[10px] font-medium text-emerald-500/60 uppercase tracking-tight italic">Inter&eacute;s real en tiempo real</p>
        </div>
    </section>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <div class="bg-surface-dark border border-border-dark rounded-3xl p-8">
            <h2 class="text-xl font-black text-white mb-6 uppercase tracking-tighter italic flex items-center gap-2">
                <span class="material-symbols-outlined text-primary">bolt</span> Tareas Urgentes
            </h2>
            <div class="space-y-4">
                <?php if($stats['verificaciones'] > 0): ?>
                <div class="flex items-center justify-between p-4 bg-black/40 rounded-2xl border border-gold/20">
                    <div class="flex items-center gap-3">
                        <span class="material-symbols-outlined text-gold">id_card</span>
                        <span class="text-sm font-bold">Hay <?= $stats['verificaciones'] ?> perfiles esperando verificaci&oacute;n</span>
                    </div>
                    <a href="<?= base_url('admin/verificaciones') ?>" class="bg-gold text-black px-4 py-2 rounded-lg font-black text-[10px] uppercase">Revisar ahora</a>
                </div>
                <?php endif; ?>

                <?php if($stats['resenas'] > 0): ?>
                <div class="flex items-center justify-between p-4 bg-black/40 rounded-2xl border border-blue-500/20">
                    <div class="flex items-center gap-3">
                        <span class="material-symbols-outlined text-blue-500">rate_review</span>
                        <span class="text-sm font-bold"><?= $stats['resenas'] ?> rese&ntilde;as necesitan moderaci&oacute;n</span>
                    </div>
                    <a href="<?= base_url('admin/resenas') ?>" class="bg-blue-500 text-white px-4 py-2 rounded-lg font-black text-[10px] uppercase">Aprobar</a>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="bg-gradient-to-br from-surface-dark to-black border border-border-dark rounded-3xl p-8 flex flex-col items-center justify-center text-center">
            <span class="material-symbols-outlined text-6xl text-primary/20 mb-4">analytics</span>
            <h2 class="text-xl font-black text-white italic">Panel Control de Calientitas</h2>
            <p class="text-gray-500 text-sm mt-2 max-w-xs">Bienvenido al n&uacute;cleo de gesti&oacute;n. Desde aqu&iacute; controlas toda la red de modelos y la seguridad del contenido.</p>
        </div>
    </div>
</div>
<?= $this->endSection() ?>