<?php

namespace App\Models;

use CodeIgniter\Model;

class Modelo extends Model
{
    protected $table            = 'modelos';
    protected $primaryKey       = 'id';
    
    protected $allowedFields = [
        'nombre', 'edad', 'comuna', 'descripcion', 'precio_hora', 
        'servicios', 'verificada', 'vip', 'disponible', 'foto_principal'
    ];
    
    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    
    // ← QUITA $casts (causa error)
    
    public function disponibles()
    {
        return $this->where('disponible', 1)
                    ->orderBy('vip', 'DESC')
                    ->orderBy('created_at', 'DESC')
                    ->limit(12)
                    ->findAll();
    }
}
