<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        // 1. Verificación básica: ¿Está logueado?
        if (!session()->get('isLoggedIn')) {
            return redirect()->to(base_url('login'))->with('error', 'Debes iniciar sesión primero.');
        }

        // 2. Verificación avanzada: ¿Tiene el rol necesario?
        // Si pasamos argumentos en la ruta (ej: auth:admin), validamos el rol
        if (!empty($arguments)) {
            $rolUsuario = session()->get('rol');
            
            // Si el rol del usuario no está en la lista de permitidos para esa ruta
            if (!in_array($rolUsuario, $arguments)) {
                // Lo mandamos a su panel correspondiente según su rol real
                return $this->redirectByRole($rolUsuario);
            }
        }
    }

    private function redirectByRole($rol) {
        switch ($rol) {
            case 'admin': return redirect()->to(base_url('admin/dashboard'));
            case 'modelo': return redirect()->to(base_url('modelo/dashboard'));
            case 'usuario': return redirect()->to(base_url('/'));
            default: return redirect()->to(base_url('/'));
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null) {}
}