<?php
/*
namespace App\Controllers;

use App\Models\UsuarioModel;

class Registro extends BaseController
{
    public function index()
    {
        if (session()->get('isLoggedIn')) {
            return redirect()->to('/admin/dashboard');
        }
        return view('auth/registro');
    }

        public function registrar() {
        $usuarioModel = new \App\Models\UsuarioModel();
    
        // 1. BLOQUEO ANTI-BOT (Honeypot)
        if (!empty($this->request->getPost('hp_field'))) {
            return redirect()->to(base_url('/'))->with('error', 'Actividad sospechosa detectada.');
        }
    
        // 2. VALIDACIONES REFORZADAS
        $rules = [
            'nombre'       => 'required|min_length[3]|max_length[50]',
            'email'        => 'required|valid_email|is_unique[usuarios.email]',
            'password'     => 'required|min_length[6]',
            'pass_confirm' => 'required|matches[password]',
            'rol'          => 'required|in_list[modelo,usuario]'
        ];
    
        $messages = [
            'email' => [
                'is_unique' => 'Este correo electrónico ya se encuentra registrado.',
                'valid_email' => 'Por favor, ingresa un formato de correo válido.'
            ],
            'pass_confirm' => [
                'matches' => 'Las contraseñas ingresadas no coinciden.'
            ],
            'nombre' => [
                'min_length' => 'El nombre debe tener al menos 3 caracteres.'
            ]
        ];
    
        if (!$this->validate($rules, $messages)) {
            $errorString = implode(' ', $this->validator->getErrors());
            return redirect()->back()->withInput()->with('error', 'Error en el registro: ' . $errorString);
        }
    
        // 3. PREPARACIÓN DE DATOS
        $rol = $this->request->getPost('rol');
        $data = [
            'nombre'   => trim($this->request->getPost('nombre')),
            'email'    => strtolower(trim($this->request->getPost('email'))), 
            'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
            'rol'      => $rol,
            'activo'   => 1
        ];
    
        // 4. INSERCIÓN Y NOTIFICACIÓN
        try {
            if ($usuarioModel->insert($data)) {
                
                // --- INICIO DE SISTEMA DE CORREOS ---
                helper('email');
    
                $emailData = [
                    'nombre' => $data['nombre'],
                    'email'  => $data['email'],
                    'rol'    => $data['rol']
                ];
    
                // 1. Notificación al Usuario/Modelo
                enviar_notificacion(
                    $data['email'], 
                    '¡Bienvenido a Calientitas! 🔥', 
                    'bienvenida_usuario', 
                    $emailData
                );
    
                // 2. Notificación al Administrador
                enviar_notificacion(
                    'hola@kmarketexpress.cl', 
                    'NUEVO REGISTRO: ' . strtoupper($data['rol']), 
                    'admin_nuevo_usuario', 
                    $emailData
                );
                // --- FIN DE SISTEMA DE CORREOS ---
    
                $exitoMsg = ($rol === 'modelo') 
                    ? '¡Cuenta de Modelo creada! Inicia sesión para configurar tu perfil.' 
                    : '¡Registro exitoso! Ya puedes iniciar sesión como usuario.';
    
                return redirect()->to(base_url('login'))->with('success', $exitoMsg);
            } else {
                return redirect()->back()->withInput()->with('error', 'No se pudo completar el registro.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('error', 'Error técnico: ' . $e->getMessage());
        }
    }
}*/