<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;

class Mantenimiento extends BaseController
{
    public function resetSistema()
    {
        // Validar por EMAIL en lugar de ID para asegurar el acceso
    if (session()->get('email') !== 'eliasfigueroamartinez@gmail.com') {
        return "Acceso denegado. Tu email (" . session()->get('email') . ") no tiene permisos de Super Admin.";
    }

        $db = \Config\Database::connect();
        $db->transStart(); // Iniciar transaccin por seguridad

        // --- 1. LIMPIEZA DE BASE DE DATOS ---

        // Tablas que se vacan por completo (Truncate)
        $tablasVaciar = [
            'clics_contacto',
            'favoritos',
            'modelo_historias',
            'modelo_multimedia',
            'recuperacion_password',
            'resenas',
            'visitas_modelos'
        ];

        foreach ($tablasVaciar as $tabla) {
            $db->table($tabla)->truncate();
        }

        // Limpiar Modelos (Delete normal para respetar relaciones)
        $db->table('modelos')->where('id >', 0)->delete();
        $db->query("ALTER TABLE modelos AUTO_INCREMENT = 1");

        // Limpiar Usuarios (EXCEPTO EL ADMIN ID 6)
        $db->table('usuarios')->where('id !=', 6)->delete();
        $db->query("ALTER TABLE usuarios AUTO_INCREMENT = 7");

        // --- 2. LIMPIEZA DE ARCHIVOS F01SICOS ---
        // Definimos las rutas exactas que me proporcionaste
        $carpetas = [
            'uploads/modelos/documentos/',
            'uploads/modelos/fotos/',
            'uploads/modelos/historias/',
            'uploads/modelos/videos/',
            'uploads/verificaciones/'
        ];

        $archivosBorrados = 0;

        foreach ($carpetas as $carpeta) {
            // FCPATH apunta a la carpeta /public/ de CodeIgniter
            $path = FCPATH . $carpeta;
            
            if (is_dir($path)) {
                // glob($path . '*') busca todos los archivos dentro
                $files = glob($path . '*'); 
                foreach ($files as $file) {
                    // Evitamos borrar carpetas internas, el index.html o fotos por defecto
                    if (is_file($file) && 
                        !str_contains($file, 'index.html') && 
                        !str_contains($file, 'default') &&
                        !str_contains($file, '.htaccess')) {
                        
                        if (unlink($file)) {
                            $archivosBorrados++;
                        }
                    }
                }
            }
        }

        $db->transComplete();

        if ($db->transStatus() === false) {
            return "Error crtico: La base de datos no pudo limpiarse.";
        }

        return "SISTEMA LIMPIO: Tablas vaciadas y " . $archivosBorrados . " archivos multimedia eliminados. Ests listo para empezar de cero.";
    }
}