<?php

namespace App\Controllers;

use App\Models\ModeloModel;

class Admin extends BaseController
{
    protected $modeloModel;
    protected $db;

    public function __construct() {
        $this->modeloModel = new ModeloModel();
        $this->db = \Config\Database::connect();
        helper(['url', 'form']);
    }

    public function index()
    {
        // 1. Estadsticas para los cuadros (Cards)
        $totalModelos = $this->modeloModel->where('activo', 1)->countAllResults();
        
        $pendientesVerificar = $this->modeloModel->where('verificada', 0)
                                                ->where('documento_identidad !=', '')
                                                ->countAllResults();

        $totalResenasPendientes = $this->db->table('resenas')
                                           ->where('aprobado', 0)
                                           ->countAllResults();

        // 2. Clics de WhatsApp realizados hoy
        $hoy = date('Y-m-d');
        // Cambia 'created_at' por 'fecha'
        $clicsHoy = $this->db->table('clics_contacto')
                     ->where('DATE(fecha)', $hoy)
                     ->countAllResults();

        $data = [
            'titulo'  => 'Panel de Control - Calientitas',
            'usuario' => session()->get('nombre'),
            'rol'     => session()->get('rol'),
            'stats'   => [
                'modelos'        => $totalModelos,
                'verificaciones' => $pendientesVerificar,
                'resenas'        => $totalResenasPendientes,
                'clics'          => $clicsHoy
            ]
        ];

        return view('admin/dashboard', $data);
    }

   public function verificaciones() {
    return "ESTOY EN EL CONTROLADOR RAIZ (Admin.php)";
}
    public function resenas() {
    $db = \Config\Database::connect();
    
    // Traemos rese09as pendientes con el nombre de la modelo y el cliente
    $pendientes = $db->table('resenas')
        ->select('resenas.*, modelos.nombre_artistico, usuarios.nombre as cliente')
        ->join('modelos', 'modelos.id = resenas.modelo_id')
        ->join('usuarios', 'usuarios.id = resenas.usuario_id')
        ->where('resenas.aprobado', 0)
        ->orderBy('resenas.created_at', 'DESC')
        ->get()->getResultArray();

    $data = [
        'usuario' => session()->get('nombre'),
        'rol'     => session()->get('rol'),
        'titulo'  => "Moderacin de Rese09as",
        'modelos' => $pendientes // Lo pasamos como 'modelos' para ser consistentes
    ];

    return view('admin/resenas/index', $data);
}
}